/// Section Begin  - CCSSP DHTM 1 (JavaScript 1.2)
// eHelp Corporation Dynamic HTML JavaScript 
// Copyright 1998-2000 eHelp Corporation.All rights reserved.
// Version=4.45

// Warning:Do not modify this file.It is generated by RoboHELP and changes will be overwritten.



//Begin the definition of class CTrigger
function CTrigger( TriggerElement )
{
	// object : the trigger element. Never be null. 
	this.eleTrigger = TriggerElement;
	
	// number : the click counter number: only 3 values: 0,1,2;
	this.nCounter = 0; 
	
	//object as associative array of string:
	// the associate target ID strings; one element at least.			
	this.objStrTarget = new Object();
	this.eleTrigger.style.cursor = "hand";
	if( this.eleTrigger.tagName == "AREA" && this.eleTrigger.getAttribute("href") == "" )
		this.eleTrigger.setAttribute("href", "#") // to make a hand cursor for image map
}

CTrigger.prototype.AddTargetID = function( strTargetID )
{// add one target ID string to the objStrTarget
	if( typeof(strTargetID) != "string" )
		return ;
	if( typeof(this.objStrTarget[strTargetID]) != "string" )
		this.objStrTarget[strTargetID] = strTargetID;
}

CTrigger.prototype.OnTriggerClick = function()
{// to activate all asociated target
	var strEventType = ( (this.nCounter++)% 2 == 0 ) ? 
		"bssctrigger1" : "bssctrigger2";
		
	// to enumerate associative target element's ID string
	for( var strTargetID in this.objStrTarget ) 
		CEngine.SendEventToOneTarget( strTargetID, strEventType );
}
//End the definition of class CTrigger

//Begin the definition of class CTarget
function CTarget( TargetElement )
{
	// object : the target element. Never be null.
	this.eleTarget = TargetElement;
	this.objManager = new Object(); // object: the event manager
} 

CTarget.nPageClickCounter = 0;// static class property.

CTarget.prototype.GetAgencyObject = function(str_action_type,action_setting )
{// return the action agency ( effect )object's refernece 
	switch( str_action_type )
	{
	case "show":return new CAgencyShow( this.eleTarget, true ) ;
	case "hide":return new CAgencyShow( this.eleTarget, false ) ;

    case "flyin" : 
    	return new CAgencyFly(this.eleTarget, action_setting, true);
    case "flyout" : 
    	return new CAgencyFly(this.eleTarget, action_setting, false);
    case "spiralin" : 
    	return new CAgencySpiral(this.eleTarget, action_setting, true);
    case "spiralout" : 
    	return new CAgencySpiral(this.eleTarget, action_setting, false);
    case "zoomin" :
    	return new CAgencyZoom(this.eleTarget, action_setting, true);
    case "zoomout" : 
    	return new CAgencyZoom(this.eleTarget, action_setting, false);
    case "elastic" : 
		return new CAgencyElastic(this.eleTarget, action_setting);
		
    case "fadein" : 
    	return (CCSSP.bIsIE4)? new CAgencyAlpha(this.eleTarget, action_setting, true) : null;
    case "fadeout" :
    	return (CCSSP.bIsIE4)? new CAgencyAlpha(this.eleTarget, action_setting, false) : null;
    case "rockrollstatic" :
    case "rockroll" :
    	return (CCSSP.bIsIE4)? new CAgencyWave(this.eleTarget, action_setting, false) : null;
 
    case "glow":
    	return (CCSSP.bIsIE4)? new CAgencyGlow(this.eleTarget,action_setting) : null;
    case "dropshadow":
    	return (CCSSP.bIsIE4)? new CAgencyDropShadow(this.eleTarget,action_setting) : null;
    case "transition" :
    	return (CCSSP.bIsIE4)? new CAgencyRevealTrans(this.eleTarget,action_setting) : null;
    case "blur" :
    	return (CCSSP.bIsIE4)? new CAgencyBlur(this.eleTarget,action_setting) : null;

    case "fliph" : // all these 4 do NOT need any parameters
    case "flipv" :
    case "invert":
    case "gray" :
    	return (CCSSP.bIsIE4)? new CAgencyChangeFilter(this.eleTarget, str_action_type) : null;
    
    case "fontchange": // the effects below change the style on the fly, so won't work in Navigator
    	return (CCSSP.bIsIE4)? new CAgencyFontChange(this.eleTarget,action_setting) : null;
    case "boderchange": 
    case "stylechange":
    	return (CCSSP.bIsIE4)? new CAgencyChangeStyle(this.eleTarget,action_setting) : null;

	default: return null;
	}
}

CTarget.prototype.SetEventManager = function( 
	one_event_type,str_action_type,action_setting,event_additional)
{// to set the event manager with specified action 
	if( typeof( one_event_type ) != "string" ||	
		typeof( str_action_type ) != "string"||
		typeof( action_setting ) != "string" )
		return false;
	if( typeof(this.objManager[one_event_type]) == "undefined" )
	{
		this.objManager[one_event_type] = new Object();
		this.objManager[one_event_type].length = 0;
	}
	
	var eventAgency = this.GetAgencyObject(str_action_type,action_setting);
	if( eventAgency != null )
	{
		var ct = this.objManager[one_event_type].length ++;
		this.objManager[one_event_type][ct] = eventAgency;
		
		if( one_event_type == "bsscpageclick" )
		{// to deal with the "number of pageclick" stuff
			if( typeof(event_additional) == "number" )
				this.objManager[one_event_type][ct].nPageClick = event_additional;
			else // set the default number 
				this.objManager[one_event_type][ct].nPageClick = 1;
			
			if( (typeof(this.objManager.nMinPageClickIndex) == "undefined") ||
			    (this.objManager[one_event_type][ct].nPageClick < 
					this.objManager[one_event_type][this.objManager.nMinPageClickIndex].nPageClick) )
				this.objManager.nMinPageClickIndex = ct;
		}
		
		//hide the object blindly,SetState function will take care of the final correct state
		if( ((one_event_type == "bsscpageclick") && 
			 (this.objManager[one_event_type][ct].nPageClick == 1)) ||
			one_event_type == "bsscpageload" ||
			one_event_type == "bssctrigger1" )
			CCSSP.ShowObject( this.eleTarget, false );
		
		if( one_event_type == "bssctrigger1" || one_event_type == "bssctrigger2" )
			if( typeof( this.strTriggerEvent ) == "undefined" )
				this.strTriggerEvent = ( one_event_type == "bssctrigger1" ) ? "bssctrigger2" : "bssctrigger1";
			
		return true;
	}
	return false;
}

CTarget.prototype.OnEvent = function( strBsscEvent )
{// response to the event ( bssc format )
	if( typeof(this.objManager[strBsscEvent]) == "object" )
	{ // to get the event agency from the event manager
		var eventAgency = this.objManager[strBsscEvent];
		for( var i = 0; i < eventAgency.length; i++ )
		{
			if( strBsscEvent == "bsscpageclick" && 
			 	eventAgency[i].nPageClick != CTarget.nPageClickCounter )
				 continue;
			else if( strBsscEvent == "bsschover" && event.type == "mouseout" )
				eventAgency[i].EndEffect();
			else // to invoke the unified function in effect object	
				eventAgency[i].UpdateEffect(); 
		}
	}
}

CTarget.prototype.SetState = function( strBsscEvent )
{
	if( typeof(this.objManager[strBsscEvent]) != "object" )
		return false;

	// to get the event agency from the event manager
	var eventAgency = this.objManager[strBsscEvent];
	
	if( strBsscEvent == "bsscpageclick" )
	{// we only set the initial state for the minium number of pageclick 
		eventAgency[this.objManager.nMinPageClickIndex].PrepareEffect();
		return true;
	}
	else
	{
		for( var i = 0; i < eventAgency.length; i++ )
			eventAgency[i].PrepareEffect(); // to invoke the unified function in effect object	 
		if( i > 0 )
			return true;
		else
			return false;
	}
}
//End the definition of class CTarget

//Begin the definition of CEngine class
function CEngine(){}// all properities are going be "class" properities

// object : as associative array of trigger objects
CEngine.objTrigger = new Object();
// object : as associative array of target objects 
CEngine.objTarget = new Object(); 

// Array : each element is a CAgencyXXX animation object
CEngine.arrAnimation = new Array();
CEngine.PerformAnimation = function( nIndex )
{// animation : update effects function
	CEngine.arrAnimation[nIndex].UpdateEffect();
}

CEngine.AddOneTrigger = function(TriggerID,TriggerElement)
{// add one Trigger object into the trigger array
	if( typeof(TriggerID) != "string" || TriggerElement == null ||
	    typeof(TriggerElement) != "object" )
		return;
	if( typeof(CEngine.objTrigger[TriggerID] ) != "object" )
		CEngine.objTrigger[TriggerID] = new CTrigger(TriggerElement);
}
	
CEngine.AddOneTarget = function(TargetID, TargetElement)
{// add one Target object into the target array
	if( typeof(TargetID) != "string" || TargetElement == null ||
		typeof(TargetElement) != "object" )
		return;
	if( typeof(CEngine.objTarget[TargetID]) != "object" )
		CEngine.objTarget[TargetID] = new CTarget( TargetElement );
}

CEngine.SendEventToOneTarget = function(strTargetID, strBsscEvent )
{// to activate one target object
	if( typeof(CEngine.objTarget[strTargetID]) == "object" ) 
	{
		if( strBsscEvent == "bssctrigger1" || strBsscEvent == "bssctrigger2" )
		{//now, the "bssctrigger1" and "bssctrigger2" work like a toggle
			if( strBsscEvent == CEngine.objTarget[strTargetID].strTriggerEvent )
				strBsscEvent = (strBsscEvent == "bssctrigger1") ? "bssctrigger2" : "bssctrigger1";
			CEngine.objTarget[strTargetID].strTriggerEvent = strBsscEvent;
		}
		CEngine.objTarget[strTargetID].OnEvent( strBsscEvent );
	}
}

CEngine.SendEventToAllTarget = function( strBsscEvent )
{ //to activate all target associative to the BSSC event
	for( var strTargetID in CEngine.objTarget ) //to enumerate all target
		CEngine.SendEventToOneTarget( strTargetID, strBsscEvent );
}

CEngine.SetOneTargetInitialState = function( strTargetID )
{// only invoked after ALL effects for the target have been set
	if( typeof(CEngine.objTarget[strTargetID]) == "object" ) 
	{// to get target object
		var objTarget = CEngine.objTarget[strTargetID];
		if( objTarget.SetState( "bsscpageload" ) == false )
		{
			objTarget.SetState( "bsscpageclick" );
			objTarget.SetState( "bssctrigger1" );
		}
	}
}

CEngine.AdjustPageClickCounter = function()
{
	var nAdjustedClickCounter = CTarget.nPageClickCounter;
	var bAdjusted = false;
	for( var strTargetID in CEngine.objTarget ) //to enumerate all target
	{// try to find the minum pageCliclConter greater than CTarget.nPageClickCounter
		var objEventPageClick = CEngine.objTarget[strTargetID].objManager.bsscpageclick;
		if( objEventPageClick != null )
		{
			for( var i = 0; i < objEventPageClick.length; i++ )
			{
				var nOtherPageClick = objEventPageClick[i].nPageClick;
				if( nOtherPageClick == CTarget.nPageClickCounter )
					return;
				if( nOtherPageClick > CTarget.nPageClickCounter )
				{
					if( !bAdjusted )
					{
						nAdjustedClickCounter = nOtherPageClick;
						bAdjusted = true;
					}
					else if( nOtherPageClick < nAdjustedClickCounter )
						nAdjustedClickCounter = nOtherPageClick;
				}
			}
		}
	}
	CTarget.nPageClickCounter = nAdjustedClickCounter;
}

CEngine.OnPageLoad = function()
{ 	
	// first, to set all target's initial state
	for( var strTargetID in CEngine.objTarget )
		CEngine.SetOneTargetInitialState( strTargetID );
	
	// to invoke all target's onpageload handler
	CEngine.SendEventToAllTarget( "bsscpageload" );
}

CEngine.OnPageClick = function()
{ // to invoke all target's onpageclick handler
	var src = CCSSP.GetEventElement( arguments[0] );
	if( src == null )
		return;
		
	var objClickedTrigger = null;
	for( var strTriggerID in CEngine.objTrigger )
	{ // to detect which trigger is clicked
		if( CCSSP.IsDescendant( CEngine.objTrigger[strTriggerID].eleTrigger,src) )
		{
			objClickedTrigger = CEngine.objTrigger[strTriggerID];
			break;
		}
	}
	
	if( objClickedTrigger != null) // the clicked trigger found
		objClickedTrigger.OnTriggerClick();
	else // no trigger is clicked
	{ // to send PageClick event to all target
		CTarget.nPageClickCounter++;
		CEngine.AdjustPageClickCounter();
		CEngine.SendEventToAllTarget( "bsscpageclick" );
	}
}	

CEngine.OnMouseOver = function()
{ // to invoke all target's onpageload handler
	var src = CCSSP.GetEventElement( arguments[0] );
	if( src == null )
		return;
		
	var strHoveredTargetID = null;
	for( var strTargetID in CEngine.objTarget )
	{ // to detect which Target is hovering on
		if( CCSSP.IsDescendant( CEngine.objTarget[strTargetID].eleTarget, src ) )
	    {
			strHoveredTargetID = strTargetID;
			break;
	    }
	}
	
	if( strHoveredTargetID != null ) // the hovered target found
		CEngine.SendEventToOneTarget( strHoveredTargetID, "bsschover" );
}

CEngine.BuildTargetObject = function(target_ID,event_type,action_type,
			action_setting, event_additional)
{// to build target object 
	// to get the target object
	if( typeof( CEngine.objTarget[target_ID] ) != "object" )
		return false;// the engine's AddOneTarget function might have failed.
	var TargetObject = CEngine.objTarget[target_ID];
	
	// to prepare the parameters for the event manager
	var arrEvent = event_type.split("|"); // to split the combined event_type string
	var arrAction = action_type.split("|");//to split the combined action_type string
	for( var trim = 0; trim < arrEvent.length; trim++ )
		arrEvent[trim] = CCSSP.TrimSpace(arrEvent[trim]);
	
	for( trim = 0; trim < arrAction.length; trim++ )
		arrAction[trim] = CCSSP.TrimSpace(arrAction[trim]);
	
	var arrSetting = new Array(); 
	if( typeof(action_setting) == "string" )
		arrSetting = action_setting.split("|");// to split the combined action_setting string
	// to calibrate the arrays
	for( var i = arrSetting.length; i < arrAction.length; i++ )
	{
		if( typeof(arrSetting[i]) != "string" )
			 arrSetting[i] = "";
	}				 

	// to prepare for dealing with the absolute posioning element
	TargetObject.eleTarget.ABSX = CCSSP.GetObjectLeft( TargetObject.eleTarget );
	TargetObject.eleTarget.ABSY = CCSSP.GetObjectTop( TargetObject.eleTarget );

	if( arrEvent.length > 1 )
	{// if event is combined, it must be : "bssctrigger1 | bssctrigger2"
		if( arrAction.length != 2 )
			return false; // if event is combined, there must be 2 actions
		for( i = 0 ; i < 2; i++ )
		{
			if( TargetObject.SetEventManager(arrEvent[i], arrAction[i], 
				arrSetting[i], event_additional) == false )
				return false; // the event manager has not been set up
		}
	}
	else // the event_type string is not combined
	{
		for( i = 0 ; i < arrAction.length; i++ )
		{
			TargetObject.SetEventManager(event_type, arrAction[i], arrSetting[i], event_additional);
			// to validate the event manager
			if( typeof(TargetObject.objManager[event_type]) != "object" ||
					typeof(TargetObject.objManager[event_type][i]) != "object" )
				return false; // the event manager has not been set up
		}
	}
	return true;
}

CEngine.BuildTriggerObject = function(trigger_ID, target_ID)
{// to build the trigger object
	var arrTrigger = trigger_ID.split("|"); // to split the combined trigger_ID string
	for( var i = 0; i < arrTrigger.length; i ++ )
	{// to get the trigger element then add it to the trigger list
		arrTrigger[i] = CCSSP.TrimSpace( arrTrigger[i] );
		var eleTrigger = CCSSP.GetObject( arrTrigger[i] );
		if( eleTrigger == null )
			continue; // the trigger_ID string in the HTML code maybe wrong
		CEngine.AddOneTrigger( arrTrigger[i], eleTrigger );

		// to get the target object
		if( typeof( this.objTrigger[arrTrigger[i]] ) != "object" )
			continue;// the engine's AddOneTarget function might have failed.
		CEngine.objTrigger[arrTrigger[i]].AddTargetID( target_ID );
	}
}
//End the definition of CEngine class

/// Section End  - CCSSP DHTM 1 (JavaScript 1.2)

